/*
 * Decompiled with CFR 0.152.
 */
package com.ashiepleb.velocitynexus.backend.listener;

import com.ashiepleb.velocitynexus.backend.VelocityNexusBackend;
import com.ashiepleb.velocitynexus.backend.menu.MenuManager;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import org.bukkit.entity.Player;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class VelocityMessageListener
implements PluginMessageListener {
    private final VelocityNexusBackend plugin;
    private final MenuManager menuManager;

    public VelocityMessageListener(VelocityNexusBackend plugin, MenuManager menuManager) {
        this.plugin = plugin;
        this.menuManager = menuManager;
    }

    public void onPluginMessageReceived(String channel, Player player, byte[] message) {
        if (!channel.equals("velocitynexus:menu")) {
            return;
        }
        try {
            ByteArrayInputStream msgBytes = new ByteArrayInputStream(message);
            DataInputStream in = new DataInputStream(msgBytes);
            String action = in.readUTF();
            if (action.equals("OPEN_MENU")) {
                String menuId = in.readUTF();
                String menuJson = in.readUTF();
                JsonObject menuData = JsonParser.parseString(menuJson).getAsJsonObject();
                this.menuManager.openMenu(player, menuData);
                this.plugin.getLogger().info("Received OPEN_MENU request for player " + player.getName());
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to process plugin message");
            e.printStackTrace();
        }
    }
}

