/*
 * Decompiled with CFR 0.152.
 */
package com.ashiepleb.velocitynexus.backend.menu;

import com.ashiepleb.velocitynexus.backend.VelocityNexusBackend;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class MenuManager {
    private final VelocityNexusBackend plugin;
    private final Map<UUID, Inventory> openMenus;

    public MenuManager(VelocityNexusBackend plugin) {
        this.plugin = plugin;
        this.openMenus = new HashMap<UUID, Inventory>();
    }

    public void openMenu(Player player, JsonObject menuData) {
        try {
            Component title = GsonComponentSerializer.gson().deserialize((Object)menuData.get("title").getAsString());
            int rows = menuData.get("rows").getAsInt();
            Inventory inventory = Bukkit.createInventory(null, (int)(rows * 9), (Component)title);
            JsonArray items = menuData.getAsJsonArray("items");
            for (JsonElement itemElement : items) {
                JsonObject itemData = itemElement.getAsJsonObject();
                int slot = itemData.get("slot").getAsInt();
                String materialName = itemData.get("material").getAsString();
                Component displayName = GsonComponentSerializer.gson().deserialize((Object)itemData.get("displayName").getAsString());
                Material material = this.getMaterial(materialName);
                ItemStack item = new ItemStack(material);
                ItemMeta meta = item.getItemMeta();
                if (meta != null) {
                    meta.displayName(displayName);
                    JsonArray loreArray = itemData.getAsJsonArray("lore");
                    ArrayList<Component> lore = new ArrayList<Component>();
                    for (JsonElement loreElement : loreArray) {
                        Component loreLine = GsonComponentSerializer.gson().deserialize((Object)loreElement.getAsString());
                        lore.add(loreLine);
                    }
                    meta.lore(lore);
                    item.setItemMeta(meta);
                }
                inventory.setItem(slot, item);
            }
            player.openInventory(inventory);
            this.openMenus.put(player.getUniqueId(), inventory);
            this.plugin.getLogger().info("Opened menu for player " + player.getName());
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to open menu for player " + player.getName());
            e.printStackTrace();
        }
    }

    public boolean hasMenuOpen(Player player) {
        return this.openMenus.containsKey(player.getUniqueId());
    }

    public Inventory getOpenMenu(Player player) {
        return this.openMenus.get(player.getUniqueId());
    }

    public void closeMenu(Player player) {
        this.openMenus.remove(player.getUniqueId());
    }

    public void closeAllMenus() {
        for (UUID uuid : new HashSet<UUID>(this.openMenus.keySet())) {
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player == null || !player.isOnline()) continue;
            player.closeInventory();
        }
        this.openMenus.clear();
    }

    private Material getMaterial(String name) {
        try {
            Material material = Material.valueOf((String)name.toUpperCase());
            return material;
        }
        catch (IllegalArgumentException e) {
            return switch (name.toLowerCase()) {
                case "server", "compass" -> Material.COMPASS;
                case "emerald" -> Material.EMERALD;
                case "diamond" -> Material.DIAMOND;
                case "gold_ingot", "gold" -> Material.GOLD_INGOT;
                case "iron_ingot", "iron" -> Material.IRON_INGOT;
                case "grass_block", "grass" -> Material.GRASS_BLOCK;
                case "stone" -> Material.STONE;
                case "diamond_block" -> Material.DIAMOND_BLOCK;
                case "gold_block" -> Material.GOLD_BLOCK;
                default -> Material.PAPER;
            };
        }
    }
}

