/*
 * Decompiled with CFR 0.152.
 */
package com.ashiepleb.velocityNexus.menu;

import com.ashiepleb.velocityNexus.config.ConfigManager;
import com.ashiepleb.velocityNexus.menu.InventoryMenu;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import org.slf4j.Logger;

public class MenuManager {
    private static final MinecraftChannelIdentifier MENU_CHANNEL = MinecraftChannelIdentifier.from((String)"velocitynexus:menu");
    private final ProxyServer proxy;
    private final ConfigManager configManager;
    private final Logger logger;
    private final InventoryMenu.Builder menuBuilder;
    private final Map<UUID, InventoryMenu> openMenus;

    public MenuManager(ProxyServer proxy, ConfigManager configManager, Logger logger) {
        this.proxy = proxy;
        this.configManager = configManager;
        this.logger = logger;
        this.menuBuilder = new InventoryMenu.Builder(proxy, configManager);
        this.openMenus = new HashMap<UUID, InventoryMenu>();
        proxy.getChannelRegistrar().register(new ChannelIdentifier[]{MENU_CHANNEL});
    }

    public void openServerSelector(Player player) {
        InventoryMenu menu = this.menuBuilder.buildServerSelector();
        this.openMenus.put(player.getUniqueId(), menu);
        if (player.getCurrentServer().isEmpty()) {
            player.sendMessage((Component)Component.text((String)"\u00a7cYou must be connected to a server to use the GUI!"));
            player.sendMessage((Component)Component.text((String)"\u00a7eUse /nexus to see the server list in chat."));
            return;
        }
        this.sendMenuData(player, menu);
    }

    public void handleClick(Player player, int slot) {
        InventoryMenu menu = this.openMenus.get(player.getUniqueId());
        if (menu == null) {
            return;
        }
        InventoryMenu.MenuItem item = menu.getItem(slot);
        if (item != null && item.getAction() != null) {
            item.getAction().onClick(player);
        }
    }

    public void closeMenu(Player player) {
        this.openMenus.remove(player.getUniqueId());
    }

    private void sendMenuData(Player player, InventoryMenu menu) {
        try {
            ByteArrayOutputStream msgBytes = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(msgBytes);
            out.writeUTF("OPEN_MENU");
            out.writeUTF(menu.getId());
            JsonObject menuJson = new JsonObject();
            menuJson.addProperty("title", (String)GsonComponentSerializer.gson().serialize(menu.getTitle()));
            menuJson.addProperty("rows", (Number)menu.getRows());
            JsonArray itemsArray = new JsonArray();
            for (Map.Entry<Integer, InventoryMenu.MenuItem> entry : menu.getItems().entrySet()) {
                JsonObject itemJson = new JsonObject();
                itemJson.addProperty("slot", (Number)entry.getKey());
                itemJson.addProperty("material", entry.getValue().getMaterial());
                itemJson.addProperty("displayName", (String)GsonComponentSerializer.gson().serialize(entry.getValue().getDisplayName()));
                JsonArray loreArray = new JsonArray();
                for (Component loreLine : entry.getValue().getLore()) {
                    loreArray.add((String)GsonComponentSerializer.gson().serialize(loreLine));
                }
                itemJson.add("lore", (JsonElement)loreArray);
                itemsArray.add((JsonElement)itemJson);
            }
            menuJson.add("items", (JsonElement)itemsArray);
            out.writeUTF(menuJson.toString());
            player.getCurrentServer().ifPresent(serverConnection -> serverConnection.sendPluginMessage((ChannelIdentifier)MENU_CHANNEL, msgBytes.toByteArray()));
            this.logger.debug("Sent menu data to backend server for player {}", (Object)player.getUsername());
        }
        catch (IOException e) {
            this.logger.error("Failed to send menu data", (Throwable)e);
            player.sendMessage((Component)Component.text((String)"\u00a7cFailed to open menu. Please try again."));
        }
    }

    public void shutdown() {
        this.openMenus.clear();
    }
}

