/*
 * Decompiled with CFR 0.152.
 */
package com.ashiepleb.velocityNexus.menu;

import com.ashiepleb.velocityNexus.config.ConfigManager;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;

public class ServerSelectorMenu {
    private final ProxyServer proxy;
    private final ConfigManager configManager;
    private final MiniMessage miniMessage;

    public ServerSelectorMenu(ProxyServer proxy, ConfigManager configManager) {
        this.proxy = proxy;
        this.configManager = configManager;
        this.miniMessage = MiniMessage.miniMessage();
    }

    public void openMenu(Player player) {
        Map<String, ConfigManager.ServerConfig> servers = this.configManager.getServers();
        ArrayList<Component> menuLines = new ArrayList<Component>();
        menuLines.add(this.miniMessage.deserialize((Object)""));
        menuLines.add(this.miniMessage.deserialize((Object)this.configManager.getMenuTitle()));
        menuLines.add(this.miniMessage.deserialize((Object)"<gray><strikethrough>                                        </strikethrough>"));
        menuLines.add(this.miniMessage.deserialize((Object)""));
        ArrayList<ConfigManager.ServerConfig> sortedServers = new ArrayList<ConfigManager.ServerConfig>(servers.values());
        sortedServers.sort(Comparator.comparingInt(ConfigManager.ServerConfig::getSlot));
        for (ConfigManager.ServerConfig serverConfig : sortedServers) {
            Optional server;
            if (!serverConfig.isEnabled() || serverConfig.getPermission() != null && !player.hasPermission(serverConfig.getPermission()) || (server = this.proxy.getServer(serverConfig.getInternalName())).isEmpty()) continue;
            RegisteredServer registeredServer = (RegisteredServer)server.get();
            int playerCount = registeredServer.getPlayersConnected().size();
            Component displayName = this.miniMessage.deserialize((Object)serverConfig.getDisplayName());
            menuLines.add(((TextComponent)((TextComponent)Component.empty().append(this.miniMessage.deserialize((Object)"<gray>\u2022 </gray>"))).append(displayName)).append(this.miniMessage.deserialize((Object)(" <dark_gray>[<yellow>" + playerCount + "</yellow>]</dark_gray>"))));
            for (String descLine : serverConfig.getDescription()) {
                String processed = descLine.replace("%players%", String.valueOf(playerCount));
                menuLines.add(this.miniMessage.deserialize((Object)("  " + processed)));
            }
            menuLines.add(this.miniMessage.deserialize((Object)("  <click:run_command:/server " + serverConfig.getInternalName() + "><green><bold>[CLICK TO JOIN]</bold></green></click>")));
            menuLines.add(this.miniMessage.deserialize((Object)""));
        }
        menuLines.add(this.miniMessage.deserialize((Object)"<gray><strikethrough>                                        </strikethrough>"));
        for (Component line : menuLines) {
            player.sendMessage(line);
        }
    }

    public boolean connectToServer(Player player, String serverName) {
        Map<String, ConfigManager.ServerConfig> servers = this.configManager.getServers();
        ConfigManager.ServerConfig serverConfig = servers.get(serverName);
        if (serverConfig == null || !serverConfig.isEnabled()) {
            player.sendMessage(this.miniMessage.deserialize((Object)"<red>This server is not available!"));
            return false;
        }
        if (serverConfig.getPermission() != null && !player.hasPermission(serverConfig.getPermission())) {
            player.sendMessage(this.miniMessage.deserialize((Object)this.configManager.getNoPermissionMessage()));
            return false;
        }
        Optional server = this.proxy.getServer(serverName);
        if (server.isEmpty()) {
            player.sendMessage(this.miniMessage.deserialize((Object)this.configManager.getOfflineServerMessage()));
            return false;
        }
        ((CompletableFuture)((RegisteredServer)server.get()).ping().thenAccept(ping -> player.createConnectionRequest((RegisteredServer)server.get()).fireAndForget())).exceptionally(throwable -> {
            player.sendMessage(this.miniMessage.deserialize((Object)this.configManager.getOfflineServerMessage()));
            return null;
        });
        return true;
    }
}

