/*
 * Decompiled with CFR 0.152.
 */
package com.ashiepleb.velocityNexus.commands;

import com.ashiepleb.velocityNexus.menu.MenuManager;
import com.ashiepleb.velocityNexus.menu.ServerSelectorMenu;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.Player;
import net.kyori.adventure.text.minimessage.MiniMessage;

public class ServerCommand
implements SimpleCommand {
    private final MenuManager menuManager;
    private final ServerSelectorMenu textMenu;
    private final MiniMessage miniMessage;

    public ServerCommand(MenuManager menuManager, ServerSelectorMenu textMenu) {
        this.menuManager = menuManager;
        this.textMenu = textMenu;
        this.miniMessage = MiniMessage.miniMessage();
    }

    public void execute(SimpleCommand.Invocation invocation) {
        CommandSource commandSource = invocation.source();
        if (!(commandSource instanceof Player)) {
            invocation.source().sendMessage(this.miniMessage.deserialize((Object)"<red>Only players can use this command!"));
            return;
        }
        Player player = (Player)commandSource;
        String[] args = (String[])invocation.arguments();
        if (args.length == 0) {
            this.menuManager.openServerSelector(player);
            return;
        }
        String serverName = args[0];
        this.textMenu.connectToServer(player, serverName);
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        return invocation.source().hasPermission("velocitynexus.server");
    }
}

