/*
 * Decompiled with CFR 0.152.
 */
package com.ashiepleb.velocityNexus.menu;

import com.ashiepleb.velocityNexus.config.ConfigManager;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;

public class InventoryMenu {
    private final String id;
    private final Component title;
    private final int rows;
    private final Map<Integer, MenuItem> items;

    public InventoryMenu(String id, Component title, int rows) {
        this.id = id;
        this.title = title;
        this.rows = rows;
        this.items = new HashMap<Integer, MenuItem>();
    }

    public String getId() {
        return this.id;
    }

    public Component getTitle() {
        return this.title;
    }

    public int getRows() {
        return this.rows;
    }

    public int getSize() {
        return this.rows * 9;
    }

    public void setItem(int slot, MenuItem item) {
        if (slot >= 0 && slot < this.getSize()) {
            this.items.put(slot, item);
        }
    }

    public MenuItem getItem(int slot) {
        return this.items.get(slot);
    }

    public Map<Integer, MenuItem> getItems() {
        return Collections.unmodifiableMap(this.items);
    }

    public static class MenuItem {
        private final String material;
        private final Component displayName;
        private final List<Component> lore;
        private final MenuAction action;

        public MenuItem(String material, Component displayName, List<Component> lore, MenuAction action) {
            this.material = material;
            this.displayName = displayName;
            this.lore = lore;
            this.action = action;
        }

        public String getMaterial() {
            return this.material;
        }

        public Component getDisplayName() {
            return this.displayName;
        }

        public List<Component> getLore() {
            return this.lore;
        }

        public MenuAction getAction() {
            return this.action;
        }
    }

    public static class Builder {
        private final ProxyServer proxy;
        private final ConfigManager configManager;
        private final MiniMessage miniMessage;

        public Builder(ProxyServer proxy, ConfigManager configManager) {
            this.proxy = proxy;
            this.configManager = configManager;
            this.miniMessage = MiniMessage.miniMessage();
        }

        public InventoryMenu buildServerSelector() {
            String menuTitle = this.configManager.getMenuTitle();
            int rows = this.configManager.getMenuRows();
            InventoryMenu menu = new InventoryMenu("server-selector", this.miniMessage.deserialize((Object)menuTitle), rows);
            Map<String, ConfigManager.ServerConfig> servers = this.configManager.getServers();
            for (ConfigManager.ServerConfig serverConfig : servers.values()) {
                if (!serverConfig.isEnabled()) continue;
                int playerCount = this.proxy.getServer(serverConfig.getInternalName()).map(server -> server.getPlayersConnected().size()).orElse(0);
                ArrayList<Component> lore = new ArrayList<Component>();
                for (String line : serverConfig.getDescription()) {
                    String processed = line.replace("%players%", String.valueOf(playerCount));
                    lore.add(this.miniMessage.deserialize((Object)processed));
                }
                MenuItem item = new MenuItem(serverConfig.getIcon(), this.miniMessage.deserialize((Object)serverConfig.getDisplayName()), lore, player -> this.connectToServer(player, serverConfig));
                menu.setItem(serverConfig.getSlot(), item);
            }
            return menu;
        }

        private void connectToServer(Player player, ConfigManager.ServerConfig serverConfig) {
            RegisteredServer currentServer;
            if (serverConfig.getPermission() != null && !player.hasPermission(serverConfig.getPermission())) {
                player.sendMessage(this.miniMessage.deserialize((Object)this.configManager.getNoPermissionMessage()));
                return;
            }
            if (player.getCurrentServer().isPresent() && (currentServer = ((ServerConnection)player.getCurrentServer().get()).getServer()).getServerInfo().getName().equals(serverConfig.getInternalName())) {
                player.sendMessage(this.miniMessage.deserialize((Object)"<gray>You are already connected to this server!"));
                return;
            }
            Optional serverOptional = this.proxy.getServer(serverConfig.getInternalName());
            if (serverOptional.isEmpty()) {
                player.sendMessage(this.miniMessage.deserialize((Object)this.configManager.getOfflineServerMessage()));
                return;
            }
            RegisteredServer server = (RegisteredServer)serverOptional.get();
            player.createConnectionRequest(server).connect().thenAccept(result -> {
                if (!result.isSuccessful()) {
                    player.sendMessage(this.miniMessage.deserialize((Object)this.configManager.getOfflineServerMessage()));
                }
            });
        }
    }

    @FunctionalInterface
    public static interface MenuAction {
        public void onClick(Player var1);
    }
}

